﻿$(document).ready(function () {
    lookAndFeelTranslationEditor.$context = $("#translate");
    lookAndFeelTranslationEditor.initialize();
    lookAndFeelTranslationEditor.bindGeneralEvents();
    lookAndFeelTranslationEditor.bindLookAndFeelEvents();
});

var lookAndFeelTranslationEditor = {
    $context: null,
    questionnaireId: 0,
    initialize: function () {
        $(".v-qeRichEditText", lookAndFeelTranslationEditor.$context).a4richTextEditor({ inline: true, library: true, piping: true, piping_system: true });
    },
    bindGeneralEvents: function () {
        $(".v-translateLanguage, .v-referenceLanguage", lookAndFeelTranslationEditor.$context).each(function () {
            $(this).data("prev", $(this).val());
        });

        $(".v-translateLanguage, .v-referenceLanguage, .v-themeSelector", lookAndFeelTranslationEditor.$context).on("change", function () {
            var select = $(this);

            var currentValue = select.val();
            var previousValue = select.data("prev");

            if (HasUnsavedChanges()) {
                modalDialog.showUnsavedChangesDialog(function () {
                    select.val(previousValue);
                    $.when(lookAndFeelTranslationEditor.saveLookAndFeel())
                     .then(function () {
                         select.val(currentValue);
                         select.data("prev", currentValue);
                         lookAndFeelTranslationEditor.updateLookAndFeelEditor();
                     });
                }, function () {
                    select.data("prev", currentValue);
                    lookAndFeelTranslationEditor.updateLookAndFeelEditor();
                }, function () {
                    select.val(previousValue);
                });
            } else {
                select.data("prev", currentValue);
                lookAndFeelTranslationEditor.updateLookAndFeelEditor();
            }
        });

        $(".v-saveLookAndFeel").on("click", function () {
            lookAndFeelTranslationEditor.saveLookAndFeel();
        });

        $(".v-cancel").on("click", function () {
            location.reload();
        });

        $(".v-print").on("click", function () {
            window.print();
        });
    },
    bindLookAndFeelEvents: function () {

        lookAndFeelTranslationEditor.$context.on("change", ".v-translationTextBox", function () {
            $(this).attr("data-changed", "true");
        });
        lookAndFeelTranslationEditor.$context.on("change", ".image-selector", function () {
            var currentVal = $(this).val();
            var strippedVal = stripFilePath(currentVal);
            $(this).val(strippedVal).attr("data-changed", "true");
        });
    },
    updateLookAndFeelEditor: function () {
        var $translationEdition = $("#lookAndFeelTranslationEditor .v-translatorContainer");
        var translateLanguage = $(".v-translateLanguage").val();
        var referenceLanguage = $(".v-referenceLanguage").val();
        var blockThemeId = $(".v-themeSelector").val();

        args = {
            referenceLanguageCode: referenceLanguage,
            translateLanguageCode: translateLanguage,
            blockThemeId: blockThemeId
        };

        a4.callServerMethod(a4.getSurveyAction("GetLookAndFeelEditor", "Translate", { surveyId: lookAndFeelTranslationEditor.questionnaireId }), args, function (result) {            
            $translationEdition[0].innerHTML = result;

            lookAndFeelTranslationEditor.initialize();
            lookAndFeelTranslationEditor.bindLookAndFeelEvents();
            a4ImageSelector.bindElements($("#lookAndFeelTranslationEditor"));
        }, null, { blockElement: $("#translate"), blockElementTimeout: 0, dataType: "html" });
    },
    saveLookAndFeel: function () {
        var themeTexts = {};
        var shortcutTexts = {};

        $(".v-themeText[data-changed='true']", lookAndFeelTranslationEditor.$context).map(function () {
            return TextObject(themeTexts, $(this));
        });
        $(".v-shortcutText[data-changed='true']", lookAndFeelTranslationEditor.$context).map(function () {
            return TextObject(shortcutTexts, $(this));
        });

        var toLanguage = $(".v-translateLanguage", lookAndFeelTranslationEditor.$context).val();
        var themeSelector = $(".v-themeSelector", lookAndFeelTranslationEditor.$context)
        var themeBlockId = themeSelector.length > 0 ? themeSelector.val() : 0;

        var args = {
            themeBlockId: themeBlockId,
            themeTexts: $.isEmptyObject(themeTexts) ? null : themeTexts,
            shortcutTexts: $.isEmptyObject(shortcutTexts) ? null : shortcutTexts,
            toLanguage: toLanguage
        };

        return a4.callServerMethod(a4.getSurveyAction("UpdateLookAndFeel", "Translate", { surveyId: lookAndFeelTranslationEditor.questionnaireId }), args, function (result) {
            a4.showSuccessMessage(resources.SuccessMessage, 2000);

            lookAndFeelTranslationEditor.updateLookAndFeelEditor();

            surveyMenu.refresh();
        }, null, { blockElement: $("#translate") });
    }
}

function stripFilePath(filePath) {
    return filePath.split('/').pop();
}

function TextObject(texts, $textBox) {
    var key = $textBox.attr("data-key");

    if ($textBox.hasClass("image-selector") && $textBox.attr("data-url")) {
        texts[key] = $textBox.attr("data-url").trim();
    } else {
        texts[key] = a4.getInputValue($textBox).trim();
    }
}

function HasUnsavedChanges() {
    return $(".v-translationTextBox[data-changed='true']", lookAndFeelTranslationEditor.$context).length > 0;
}